package com.richard_gauthier.JaugeAiguille
{
	import com.richard_gauthier.TexteEnBitmap.TexteEnBitmap;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	
	/**
	 * ...
	 * @author rg
	 */
	public class JaugeAiguille extends Sprite
	{
		[Embed(source="bar3.png")]
		private var bar1C:Class;
		private var bar1:Bitmap = new bar1C;
		
		private var bar1S:Sprite = new Sprite();
		private var bar2S:Sprite = new Sprite();
		
		private var leTexte:TextField = new TextField();
		public var couleur:uint = 0x000000;
		
		private var miniG:Number = 0;
		private var maxiG:Number = 100;
		
		private var transEnbitmap:TexteEnBitmap = new TexteEnBitmap();
		private var monBitmap:Bitmap;
		
		public function JaugeAiguille(leTitre:String = "Le Titre", unite:String = "Unité", mini:Number = 0, maxi:Number = 100)
		{
			if (mini < maxi)
			{
				maxiG = maxi;
				miniG = mini;
			}
			
			bar1S.addChild(bar1);
			addChild(bar1S);
			addChild(bar2S);
			
			var ecart:Number = (maxiG - miniG) / 5;
			
			var angle : Number;
			var angle1 : Number;
				
			for (var i:int = 0; i < 6; i++)
			{
				angle = (180 - i* 180/5)*Math.PI /180;
				angle1 = (- 90 + i* 180/5);
				label("" + (miniG + ecart * i), 157 * Math.cos(angle) + bar1S.width/2 , - 157 * Math.sin(angle) + 203 , 4,angle1);
				
			}
			
			//Placer l'unité
			label(unite, bar1S.width / 2, 180, 6);
			//Placer le titre
			label(leTitre, bar1.width / 2, bar1.height + 10 , 0 );
			
			var formatTexte:TextFormat = new TextFormat();
			formatTexte.font = "tahoma";
			formatTexte.size = 22;
			//formatTexte.bold = true;
			//formatTexte.color = couleur;
			formatTexte.align = TextFormatAlign.CENTER;
			
			leTexte.width = 50;
			leTexte.height = 30;
			//leTexte.autoSize = TextFieldAutoSize.CENTER;
			leTexte.defaultTextFormat = formatTexte;
			leTexte.text =  "1000";
			leTexte.x =  bar1S.width / 2 - leTexte.width / 2;
			leTexte.y =  130;
			addChild(leTexte);
			setValue(miniG);
		}
		
		public function setValue(value:Number):void
		{
			var longueur : Number = 160;
			
			
			leTexte.text = "" + value;
			
			if (value < miniG)
				value = 0;
			else if (value > maxiG)
				value = 180;
			else
			{
				if(miniG >= 0) value = 180 / (maxiG - miniG) * value;
				else if(miniG < 0 ) value = 180 / (maxiG - miniG) * (value - miniG);
			
			}
			
			
			value = (180 - value ) * Math.PI / 180;
			bar2S.graphics.clear();
			bar2S.graphics.lineStyle(5, 0xff0000);
			bar2S.graphics.moveTo(bar1S.width/2, 203);
			bar2S.graphics.lineTo(longueur * Math.cos(value) + bar1S.width/2 , - longueur * Math.sin(value) + 203);
			
		
		}
		
				
		private function label(texte:String, posiX:Number, posiY:Number, NbCaracteres:int = -1, angle :Number = 0 ):void
		{
			if (NbCaracteres > 0)
				if (texte.length > NbCaracteres)
					texte = texte.substr(0, NbCaracteres);
			
			var monSprite :Sprite = new Sprite();		
			monBitmap = new Bitmap(transEnbitmap.transformerTexteEnBitmap(texte ));
			monBitmap.x = - monBitmap.width / 2;
			monBitmap.y = - monBitmap.height ;
			
			monSprite.addChild(monBitmap);
			monSprite.x = posiX;
			monSprite.y = posiY;
			//528
			monSprite.rotation = angle;
			monBitmap.cacheAsBitmap = true;
			
			addChild(monSprite);
		
			//leTexteMesure.addEventListener(MouseEvent.CLICK,mouseClick)
		
		}
	
	}

}